<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= esc($title ?? 'Visi, Misi & Tujuan') ?></title>

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="icon" href="<?= base_url('assets/images/logo1.png') ?>" type="image/png">
  
  <style>
    .sidebar { width: 280px; min-height: 100vh; overflow-y: auto; }
    .sidebar a { text-decoration: none; }
    .sidebar .active { background: rgba(13,110,253,.12); border-radius: .5rem; }
    .sub-menu { padding-left: 1rem; }
    .sub-menu .list-group-item {
      font-size: 0.9rem;
      padding: 0.5rem 1rem;
      border: none;
    }
    .menu-toggle {
      cursor: pointer;
      position: relative;
    }
    .menu-toggle::after {
      content: '▼';
      position: absolute;
      right: 1rem;
      font-size: 0.75rem;
      transition: transform 0.3s;
    }
    .menu-toggle.collapsed::after {
      transform: rotate(-90deg);
    }
    body { background: #f6f8fb; }
    .page-wrap { max-width: 980px; }
    .hero-title { letter-spacing: .2px; }
    .soft-card {
      border: 0;
      border-radius: 18px;
      box-shadow: 0 10px 30px rgba(16, 24, 40, .08);
    }
    .nav-pills .nav-link { border-radius: 999px; }
    textarea.form-control { border-radius: 14px; }
    .btn-rounded { border-radius: 999px; padding-inline: 18px; }
    .hint { color: #667085; font-size: .9rem; }
    .main-content { flex: 1; }
  
    /* ===== TAMBAHAN RESPONSIVE (AMAN) ===== */
    .hamburger {
      display: none;
      font-size: 1.6rem;
      color: #fff;
      cursor: pointer;
    }

    .sidebar-overlay {
      display: none;
      position: fixed;
      inset: 0;
      background: rgba(0,0,0,.45);
      z-index: 1040;
    }

    @media (max-width: 991px) {
      .hamburger {
        display: block;
      }

      .sidebar {
        position: fixed;
        top: 0;
        left: 0;
        z-index: 1050;
        background: #fff;
        transform: translateX(-100%);
        transition: transform .3s ease;
      }

      .sidebar.show {
        transform: translateX(0);
      }

      .sidebar-overlay.show {
        display: block;
      }
    }
  </style>
</head>

<body class="bg-light">

<nav class="navbar navbar-expand-lg bg-primary navbar-dark">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold" href="<?= site_url('admin') ?>">Welcome back Admin</a>

    <!-- TAMBAHAN: HAMBURGER (TIDAK MENGHAPUS APA PUN) -->
    <span class="hamburger ms-auto me-3" onclick="toggleSidebar()">☰</span>

    <div class="d-flex gap-2 align-items-center">
      <span class="text-white small">Halo, <?= esc(auth()->user()->username ?? 'Admin') ?></span>
      <a class="btn btn-outline-light btn-sm" href="<?= site_url('logout') ?>">Logout</a>
    </div>
  </div>
</nav>

<!-- TAMBAHAN: OVERLAY -->
<div class="sidebar-overlay" onclick="toggleSidebar()"></div>

<div class="d-flex">

  <!-- ===== SIDEBAR ASLI KAMU (UTUH, TIDAK DIHAPUS) ===== -->
  <aside class="sidebar bg-white border-end p-3" id="sidebar">
    <div class="fw-bold mb-2">Admin Panel</div>

    <?php
      $uri = service('uri')->getPath();

      $isInfoSekolahActive = ($uri === 'admin' || $uri === 'admin/' ||
                              str_starts_with($uri, 'admin/branding') ||
                              str_starts_with($uri, 'admin/visi-misi') ||
                              str_starts_with($uri, 'admin/kepsek') ||
                              str_starts_with($uri, 'admin/video-profile') ||
                              str_starts_with($uri, 'admin/data-sekolah') ||
                              str_starts_with($uri, 'admin/footer'));

      $isBeritaActive = (str_starts_with($uri, 'admin/berita') ||
                        str_starts_with($uri, 'admin/pengumuman') ||
                        str_starts_with($uri, 'admin/kelulusan') ||
                        str_starts_with($uri, 'admin/kegiatan') ||
                        str_starts_with($uri, 'admin/prestasi'));

      $isGaleriActive = (str_starts_with($uri, 'admin/galeri') ||
                        str_starts_with($uri, 'admin/guru-staf') ||
                        str_starts_with($uri, 'admin/siswa') ||
                        str_starts_with($uri, 'admin/video') ||
                        str_starts_with($uri, 'admin/ekstrakulikuler'));
    ?>

    <div class="list-group list-group-flush">
      <!-- Informasi Sekolah -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isInfoSekolahActive ? '' : 'collapsed' ?> <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
         data-bs-toggle="collapse"
         href="#infoSekolahMenu"
         role="button"
         aria-expanded="<?= $isInfoSekolahActive ? 'true' : 'false' ?>"
         aria-controls="infoSekolahMenu">
        Informasi Sekolah
      </a>

      <div class="collapse <?= $isInfoSekolahActive ? 'show' : '' ?>" id="infoSekolahMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= ($uri === 'admin' || $uri === 'admin/') ? 'active' : '' ?>"
             href="<?= site_url('admin') ?>">Dashboard</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/visi-misi') ? 'active' : '' ?>"
             href="<?= site_url('admin/visi-misi') ?>">Visi & Misi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kepsek') ? 'active' : '' ?>"
             href="<?= site_url('admin/kepsek') ?>">Kata Sambutan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video-profile') ? 'active' : '' ?>"
             href="<?= site_url('admin/video-profile') ?>">Video Profile</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/data-sekolah') ? 'active' : '' ?>"
             href="<?= site_url('admin/data-sekolah') ?>">Statistika</a>

             <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/footer') ? 'active' : '' ?>"
             href="<?= site_url('admin/footer') ?>">Footer</a>
        </div>
      </div>

      <!-- Berita -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isBeritaActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#beritaMenu"
         role="button"
         aria-expanded="<?= $isBeritaActive ? 'true' : 'false' ?>"
         aria-controls="beritaMenu">
        Berita
      </a>

      <div class="collapse <?= $isBeritaActive ? 'show' : '' ?>" id="beritaMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/pengumuman') ? 'active' : '' ?>"
             href="<?= site_url('admin/pengumuman') ?>">Pengumuman</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kelulusan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kelulusan') ?>">Pengumuman Kelulusan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/kegiatan') ? 'active' : '' ?>"
             href="<?= site_url('admin/kegiatan') ?>">Kegiatan</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/prestasi') ? 'active' : '' ?>"
             href="<?= site_url('admin/prestasi') ?>">Prestasi</a>
        </div>
      </div>

      <!-- Galeri -->
      <a class="list-group-item list-group-item-action menu-toggle <?= $isGaleriActive ? '' : 'collapsed' ?>"
         data-bs-toggle="collapse"
         href="#galeriMenu"
         role="button"
         aria-expanded="<?= $isGaleriActive ? 'true' : 'false' ?>"
         aria-controls="galeriMenu">
        Galeri
      </a>

      <div class="collapse <?= $isGaleriActive ? 'show' : '' ?>" id="galeriMenu">
        <div class="sub-menu">
          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/guru-staf') ? 'active' : '' ?>"
             href="<?= site_url('admin/guru-staf') ?>">Guru dan Staf</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/siswa') ? 'active' : '' ?>"
             href="<?= site_url('admin/siswa') ?>">Siswa/Siswi</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/video') ? 'active' : '' ?>"
             href="<?= site_url('admin/video') ?>">Video</a>

          <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/ekstrakurikuler') ? 'active' : '' ?>"
             href="<?= site_url('admin/ekstrakurikuler') ?>">Ekstrakulikuler</a>
        </div>
      </div>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/tentang') ? 'active' : '' ?>"
         href="<?= site_url('admin/tentang') ?>">Tentang</a>

      <a class="list-group-item list-group-item-action <?= str_starts_with($uri, 'admin/password') ? 'active' : '' ?>"
         href="<?= site_url('admin/password') ?>">Ubah Password</a>
    </div>
  </aside>

  <!-- Main Content -->
  <div class="main-content">
    <div class="container py-4 page-wrap">

      <!-- Header -->
      <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3 mb-4">
        <div>
          <h1 class="h3 mb-1 hero-title">Visi, Misi & Tujuan</h1>
          <div class="hint">Atur konten yang akan tampil di halaman publik sekolah.</div>
        </div>
      </div>

      <!-- Alerts -->
      <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success d-flex align-items-center" role="alert">
          <div class="me-2">✅</div>
          <div><?= session()->getFlashdata('success') ?></div>
        </div>
      <?php endif; ?>

      <?php if (session()->getFlashdata('errors')): ?>
        <div class="alert alert-danger" role="alert">
          <div class="fw-semibold mb-1">Ada error:</div>
          <ul class="mb-0">
            <?php foreach(session()->getFlashdata('errors') as $e): ?>
              <li><?= esc($e) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      <?php endif; ?>

      <!-- Card -->
      <div class="card soft-card">
        <div class="card-body p-4 p-md-5">

          <div class="d-flex align-items-start justify-content-between flex-wrap gap-3 mb-3">
            <div>
              <div class="fw-semibold">Edit Konten</div>
              <div class="hint">Tips: gunakan paragraf singkat. Untuk Misi/Tujuan bisa pakai poin dengan tanda "-".</div>
            </div>
          </div>

          <form action="<?= site_url('admin/visi-misi/update') ?>" method="post" id="vmForm" novalidate>
            <?= csrf_field() ?>
            <input type="hidden" name="_method" value="POST">

            <!-- Tabs -->
            <ul class="nav nav-pills gap-2 mb-3" id="vmTab" role="tablist">
              <li class="nav-item" role="presentation">
                <button class="nav-link active" id="tab-visi" data-bs-toggle="tab" data-bs-target="#pane-visi" type="button" role="tab">
                  Visi
                </button>
              </li>
              <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-misi" data-bs-toggle="tab" data-bs-target="#pane-misi" type="button" role="tab">
                  Misi
                </button>
              </li>
              <li class="nav-item" role="presentation">
                <button class="nav-link" id="tab-tujuan" data-bs-toggle="tab" data-bs-target="#pane-tujuan" type="button" role="tab">
                  Tujuan
                </button>
              </li>
            </ul>

            <div class="tab-content">
              <!-- Visi -->
              <div class="tab-pane fade show active" id="pane-visi" role="tabpanel" aria-labelledby="tab-visi">
                <label class="form-label fw-semibold">Visi</label>
                <textarea class="form-control" name="visi" rows="5" placeholder="Tulis visi sekolah..."><?= esc($row['visi'] ?? '') ?></textarea>
              </div>

              <!-- Misi -->
              <div class="tab-pane fade" id="pane-misi" role="tabpanel" aria-labelledby="tab-misi">
                <label class="form-label fw-semibold">Misi</label>
                <textarea class="form-control" name="misi" rows="7" placeholder="Tulis misi sekolah..."><?= esc($row['misi'] ?? '') ?></textarea>
                <div class="hint mt-2">Buat poin per baris, contoh: <code>- Meningkatkan ...</code></div>
              </div>

              <!-- Tujuan -->
              <div class="tab-pane fade" id="pane-tujuan" role="tabpanel" aria-labelledby="tab-tujuan">
                <label class="form-label fw-semibold">Tujuan</label>
                <textarea class="form-control" name="tujuan" rows="7" placeholder="Tulis tujuan sekolah..."><?= esc($row['tujuan'] ?? '') ?></textarea>
              </div>
            </div>

            <hr class="my-4">

            <div class="btnrow">
              <button type="submit" class="btn btn-primary" id="saveBtn">Simpan Perubahan</button>
            </div>
          </form>

        </div>
      </div>

      <div class="hint text-center mt-4">
        © <?= date('Y') ?> Admin Panel
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  const form = document.getElementById('vmForm');
  const btn  = document.getElementById('saveBtn');

  if (form && btn) {
    form.addEventListener('submit', () => {
      btn.disabled = true;
      btn.textContent = 'Menyimpan...';
    });
  }
</script>
<!-- TAMBAHAN JS (AMAN) -->
<script>
  function toggleSidebar() {
    document.getElementById('sidebar').classList.toggle('show');
    document.querySelector('.sidebar-overlay').classList.toggle('show');
  }
</script>

</body>
</html>